﻿var clients = {
    datatable: null,
    refreshDataTable: function () {
        clients.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-clients").a4datatable({
            ajaxAction: a4.getAction("GetClients", "General", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Class": "id" },
                { "Name": "Name", "Title": resources.Name, "Class": "v-name" },
                { "Name": "AdminEmail", "Title": resources.AdminEmail },
                { "Name": "Language", "Title": resources.Language },
                { "Name": "TimeZone", "Title": resources.TimeZone },
                { "Name": "Active", "Title": resources.Active, "Label": "ActiveLabel" },
                { "Name": "HasLicense", "Title": resources.HasLicense, "Label": "HasLicenseLabel", "Sortable": false },
                { "Name": "HasPanelAccess", "Title": resources.HasPanel, "Label": "HasPanelAccessLabel", "Sortable": false },
                { "Name": "HasVoxcoAnalytics", "Title": resources.VoxcoAnalytics, "Type": "boolean", "ShowIcon": true }
            ],
            defaultSorting: "Id",
            allowRowSelection: false,
            displayContextMenu: true,
            contextMenuItems: [
                { "Action": "redirect", "Params": { action: "Licenses", controller: "Licensing", area: "Admin" }, "Label": resources.Licenses },
                { "Action": "completeCases", "Params": { action: "CompletedCases", controller: "Licensing", area: "Admin" }, "Label": resources.CompletedCases },
                { "Action": "redirect", "Params": { action: "CustomExports", controller: "Panel", area: "Admin" }, "Label": resources.CustomExports, "DisplayCondition": function (data) { return data.HasPanelAccess; } },
                { "Action": "notifications", "Label": resources.Notifications },
                { "Divider": true },
                { "Action": "restore", "Label": resources.RestoreSurvey },
                { "Action": "exportAll", "Label": resources.ExportAllSurveys },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "edit", "Label": resources.Properties }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "completeCases": window.location = a4.getAction(data.params.action, data.params.controller, "Admin", { id: row.Id });
                        break;

                    case "redirect":
                        window.location = a4.getAction(data.params.action, data.params.controller, "Admin", { id: row.Id, name: row.Name });
                        break;

                    case "edit":
                        modalDialog.showWindow(a4.getAction("ClientEditor", "General", "Admin", { id: row.Id }), 700, 650, { afterClose: function () { clients.refreshDataTable(); } });
                        break;
                    case "notifications":
                        modalDialog.showWindow(a4.getAction("Edit", "Notification", "Admin", { clientId: row.Id }), 300, 700, { afterClose: function () { clients.refreshDataTable(); } });
                        break;
                    case "restore":
                        modalDialog.showWindow(a4.getAction("RestoreSurvey", "General", "Admin", { clientId: row.Id }), 700, 650, { afterClose: function () { } });
                        break;

                    case "exportAll":
                        modalDialog.showWindow(a4.getAction("ExportAllSurveys", "General", "Admin", { clientId: row.Id }), 400, 650, { afterClose: function () { } });
                        break;

                    case "delete":
                        clients.deleteClient(row.Id);
                        break;
                }
            }
        });
    },

    bindEvents: function () {
        $(document).on("click", ".h-addClient", function () {
            modalDialog.showWindow(a4.getAction("ClientEditor", "General", "Admin"), 700, 650, { afterClose: function () { clients.refreshDataTable(); } });
        });
    },

    deleteClient: function (id) {
        modalDialog.showWindow(a4.getAction("DeleteClientEditor", "General", "Admin", { id: id }), 230, 600, { afterClose: function () { clients.refreshDataTable(); } });
    },

    deactivate: function (id) {
        modalDialog.showConfirmDialog(confirmDeactivateResources, function () {
            a4.callServerMethod(a4.getAction("DeactivateClient", "General", "Admin"), { clientId: id },
                function (result) {
                    clients.refreshDataTable();
                });
        }, 250, 500, true, {});
    }
}

$(document).ready(function () {
    if ($(".v-clients").length > 0) {
        clients.initializeDataTable();
        clients.bindEvents();
    }
});


